clear

% Generate data
rng('default')
n=1000;
k=6;
x=[ones(n,1) randn(n,k-1)];
beta=(1:k)'/k;
P=logistic(x*beta);
y=rand(n,1) < P;
dat=[y x];

% Estimte the model
[bhat,shat,f,H,V,scores]=estimate_logit(y,x,zeros(n,1));


% Define the Directions
d1=eye(k);
d2=zeros((k*(k-1)),k);
ij=1;
for i=1:(k-1)
    for j=(i+1):k
        d2(ij,i)=1;
         d2(ij,j)=1;
         ij=ij+1;
         d2(ij,i)=1;
         d2(ij,j)=-1;
         ij=ij+1;
    end
end

D=[d1 d2'];   
% each column is a direction


% Now Do The Bootstrap (both the standard and the Poor (Wo)Man's

nboot=2000;
bhat_boot=zeros(nboot,k);
b_directional=zeros(nboot,(k*k));

    for iboot=1:nboot
        
        % Draw a bootstrap sample      
        ii=ceil(n*rand(n,1));
        datb=dat(ii,:);
        yboot=datb(:,1);
        xboot=datb(:,2:k+1);
        xbhat=xboot*bhat;
        
        % Calculate Estimator (for the regular bootstrap)
        bb=estimate_logit(yboot,xboot,zeros(n,1));
        bhat_boot(iboot,:)=bb';


        % Calculate Univarate Estimators (for the Poor (Wo)Man's version)
        for i=1:size(D,2)
            bb=estimate_logit(yboot,xboot*D(:,i),xbhat);
            b_directional(iboot,i)=bb;
        end
    end
    
% Bootstrap Standard Errors
shat_BS=std(bhat_boot)';
    
% Honore & Hu (2017)
OMEGA2=cov(b_directional);
OMEGA1=OMEGA2(1:k,1:k);
addpath('Sol4HV')      
[Vcf, Hcf, V, H, fctVH]= solve_for_V_and_H_Version2018(OMEGA1, OMEGA2, D, 0) ;
shat_HH=sqrt(diag(H\V/H'));

% Display The Estimated Standard Errors On the Screen
fprintf('Asymptotic Bootstrap   Ours')
pmatrix([shat shat_BS shat_HH])
